// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Intcpserver.pas' rev: 10.00

#ifndef IntcpserverHPP
#define IntcpserverHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Sysutils.hpp>	// Pascal unit
#include <Incomponent.hpp>	// Pascal unit
#include <Incontext.hpp>	// Pascal unit
#include <Inglobal.hpp>	// Pascal unit
#include <Inexception.hpp>	// Pascal unit
#include <Inintercept.hpp>	// Pascal unit
#include <Iniohandler.hpp>	// Pascal unit
#include <Iniohandlerstack.hpp>	// Pascal unit
#include <Inreply.hpp>	// Pascal unit
#include <Inscheduler.hpp>	// Pascal unit
#include <Inschedulerofthread.hpp>	// Pascal unit
#include <Inserveriohandler.hpp>	// Pascal unit
#include <Inserveriohandlerstack.hpp>	// Pascal unit
#include <Insockethandle.hpp>	// Pascal unit
#include <Instackconsts.hpp>	// Pascal unit
#include <Intcpconnection.hpp>	// Pascal unit
#include <Inthread.hpp>	// Pascal unit
#include <Inyarn.hpp>	// Pascal unit
#include <Inbasecomponent.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Intcpserver
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS TIdListenerThread;
class DELPHICLASS TInTCPServer;
typedef void __fastcall (__closure *TIdServerThreadEvent)(Incontext::TInContext* AContext);

typedef void __fastcall (__closure *TIdServerThreadExceptionEvent)(Incontext::TInContext* AContext, Sysutils::Exception* AException);

typedef void __fastcall (__closure *TIdListenExceptionEvent)(TIdListenerThread* AThread, Sysutils::Exception* AException);

class PASCALIMPLEMENTATION TInTCPServer : public Incomponent::TInComponent 
{
	typedef Incomponent::TInComponent inherited;
	
protected:
	bool FActive;
	Inscheduler::TInScheduler* FScheduler;
	Insockethandle::TInSocketHandles* FBindings;
	TMetaClass* FContextClass;
	bool FImplicitScheduler;
	bool FImplicitIOHandler;
	Inintercept::TIdServerIntercept* FIntercept;
	Inserveriohandler::TInServerIOHandler* FIOHandler;
	Classes::TThreadList* FListenerThreads;
	int FListenQueue;
	int FMaxConnections;
	Inglobal::TIdReuseSocket FReuseSocket;
	int FTerminateWaitTime;
	Classes::TThreadList* FContexts;
	TIdServerThreadEvent FOnBeforeConnect;
	TIdServerThreadEvent FOnConnect;
	TIdServerThreadEvent FOnDisconnect;
	TIdServerThreadExceptionEvent FOnException;
	TIdServerThreadEvent FOnExecute;
	TIdListenExceptionEvent FOnListenException;
	Classes::TNotifyEvent FOnAfterBind;
	Inthread::TIdNotifyThreadEvent FOnBeforeListenerRun;
	void __fastcall CheckActive(void);
	virtual void __fastcall ContextCreated(Incontext::TInContext* AContext);
	virtual void __fastcall DoAfterBind(void);
	virtual void __fastcall DoBeforeConnect(Incontext::TInContext* AContext);
	virtual void __fastcall DoConnect(Incontext::TInContext* AContext);
	virtual void __fastcall DoDisconnect(Incontext::TInContext* AContext);
	void __fastcall DoException(Incontext::TInContext* AContext, Sysutils::Exception* AException);
	virtual bool __fastcall DoExecute(Incontext::TInContext* AContext);
	void __fastcall DoListenException(TIdListenerThread* AThread, Sysutils::Exception* AException);
	virtual void __fastcall DoMaxConnectionsExceeded(Iniohandler::TInIOHandler* AIOHandler);
	int __fastcall GetDefaultPort(void);
	virtual void __fastcall InitComponent(void);
	virtual void __fastcall Loaded(void);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation);
	virtual void __fastcall SendGreeting(Incontext::TInContext* AContext, Inreply::TInReply* AGreeting);
	virtual void __fastcall SetActive(bool AValue);
	virtual void __fastcall SetBindings(const Insockethandle::TInSocketHandles* AValue);
	virtual void __fastcall SetDefaultPort(const int AValue);
	virtual void __fastcall SetIntercept(const Inintercept::TIdServerIntercept* AValue);
	virtual void __fastcall SetIOHandler(const Inserveriohandler::TInServerIOHandler* AValue);
	virtual void __fastcall SetScheduler(const Inscheduler::TInScheduler* AValue);
	virtual void __fastcall Startup(void);
	virtual void __fastcall Shutdown(void);
	void __fastcall TerminateAllThreads(void);
	void __fastcall TerminateListenerThreads(void);
	
public:
	__fastcall virtual ~TInTCPServer(void);
	__property Classes::TThreadList* Contexts = {read=FContexts};
	__property TMetaClass* ContextClass = {read=FContextClass, write=FContextClass};
	__property bool ImplicitIOHandler = {read=FImplicitIOHandler, nodefault};
	__property bool ImplicitScheduler = {read=FImplicitScheduler, nodefault};
	
__published:
	__property bool Active = {read=FActive, write=SetActive, default=0};
	__property Insockethandle::TInSocketHandles* Bindings = {read=FBindings, write=SetBindings};
	__property int DefaultPort = {read=GetDefaultPort, write=SetDefaultPort, nodefault};
	__property Inintercept::TIdServerIntercept* Intercept = {read=FIntercept, write=SetIntercept};
	__property Inserveriohandler::TInServerIOHandler* IOHandler = {read=FIOHandler, write=SetIOHandler};
	__property int ListenQueue = {read=FListenQueue, write=FListenQueue, default=15};
	__property int MaxConnections = {read=FMaxConnections, write=FMaxConnections, default=0};
	__property Classes::TNotifyEvent OnAfterBind = {read=FOnAfterBind, write=FOnAfterBind};
	__property Inthread::TIdNotifyThreadEvent OnBeforeListenerRun = {read=FOnBeforeListenerRun, write=FOnBeforeListenerRun};
	__property TIdServerThreadEvent OnBeforeConnect = {read=FOnBeforeConnect, write=FOnBeforeConnect};
	__property TIdServerThreadEvent OnConnect = {read=FOnConnect, write=FOnConnect};
	__property TIdServerThreadEvent OnExecute = {read=FOnExecute, write=FOnExecute};
	__property TIdServerThreadEvent OnDisconnect = {read=FOnDisconnect, write=FOnDisconnect};
	__property TIdServerThreadExceptionEvent OnException = {read=FOnException, write=FOnException};
	__property TIdListenExceptionEvent OnListenException = {read=FOnListenException, write=FOnListenException};
	__property Inglobal::TIdReuseSocket ReuseSocket = {read=FReuseSocket, write=FReuseSocket, default=0};
	__property int TerminateWaitTime = {read=FTerminateWaitTime, write=FTerminateWaitTime, default=5000};
	__property Inscheduler::TInScheduler* Scheduler = {read=FScheduler, write=SetScheduler};
public:
	#pragma option push -w-inl
	/* TInBaseComponent.Create */ inline __fastcall TInTCPServer(Classes::TComponent* AOwner)/* overload */ : Incomponent::TInComponent(AOwner) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TIdListenerThread : public Inthread::TInThread 
{
	typedef Inthread::TInThread inherited;
	
protected:
	Insockethandle::TInSocketHandle* FBinding;
	TInTCPServer* FServer;
	Inthread::TIdNotifyThreadEvent FOnBeforeRun;
	virtual void __fastcall AfterRun(void);
	virtual void __fastcall BeforeRun(void);
	virtual void __fastcall Run(void);
	
public:
	__fastcall TIdListenerThread(TInTCPServer* AServer, Insockethandle::TInSocketHandle* ABinding);
	__property Insockethandle::TInSocketHandle* Binding = {read=FBinding, write=FBinding};
	__property TInTCPServer* Server = {read=FServer};
	__property Inthread::TIdNotifyThreadEvent OnBeforeRun = {read=FOnBeforeRun, write=FOnBeforeRun};
public:
	#pragma option push -w-inl
	/* TInThread.Destroy */ inline __fastcall virtual ~TIdListenerThread(void) { }
	#pragma option pop
	
};


class DELPHICLASS EInTCPServerError;
class PASCALIMPLEMENTATION EInTCPServerError : public Inexception::EInException 
{
	typedef Inexception::EInException inherited;
	
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EInTCPServerError(AnsiString AMsg)/* overload */ : Inexception::EInException(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EInTCPServerError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : Inexception::EInException(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EInTCPServerError(int Ident)/* overload */ : Inexception::EInException(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EInTCPServerError(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : Inexception::EInException(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EInTCPServerError(const AnsiString Msg, int AHelpContext) : Inexception::EInException(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EInTCPServerError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : Inexception::EInException(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EInTCPServerError(int Ident, int AHelpContext)/* overload */ : Inexception::EInException(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EInTCPServerError(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : Inexception::EInException(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EInTCPServerError(void) { }
	#pragma option pop
	
};


class DELPHICLASS EIdNoExecuteSpecified;
class PASCALIMPLEMENTATION EIdNoExecuteSpecified : public EInTCPServerError 
{
	typedef EInTCPServerError inherited;
	
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EIdNoExecuteSpecified(AnsiString AMsg)/* overload */ : EInTCPServerError(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EIdNoExecuteSpecified(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : EInTCPServerError(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EIdNoExecuteSpecified(int Ident)/* overload */ : EInTCPServerError(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EIdNoExecuteSpecified(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : EInTCPServerError(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EIdNoExecuteSpecified(const AnsiString Msg, int AHelpContext) : EInTCPServerError(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EIdNoExecuteSpecified(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : EInTCPServerError(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EIdNoExecuteSpecified(int Ident, int AHelpContext)/* overload */ : EInTCPServerError(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EIdNoExecuteSpecified(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : EInTCPServerError(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EIdNoExecuteSpecified(void) { }
	#pragma option pop
	
};


class DELPHICLASS EIdTerminateThreadTimeout;
class PASCALIMPLEMENTATION EIdTerminateThreadTimeout : public EInTCPServerError 
{
	typedef EInTCPServerError inherited;
	
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EIdTerminateThreadTimeout(AnsiString AMsg)/* overload */ : EInTCPServerError(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EIdTerminateThreadTimeout(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : EInTCPServerError(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EIdTerminateThreadTimeout(int Ident)/* overload */ : EInTCPServerError(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EIdTerminateThreadTimeout(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : EInTCPServerError(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EIdTerminateThreadTimeout(const AnsiString Msg, int AHelpContext) : EInTCPServerError(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EIdTerminateThreadTimeout(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : EInTCPServerError(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EIdTerminateThreadTimeout(int Ident, int AHelpContext)/* overload */ : EInTCPServerError(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EIdTerminateThreadTimeout(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : EInTCPServerError(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EIdTerminateThreadTimeout(void) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
static const Shortint IdListenQueueDefault = 0xf;

}	/* namespace Intcpserver */
using namespace Intcpserver;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Intcpserver
